/*
 * Decompiled with CFR 0.152.
 */
package philosophers;

import concurrency.Message;
import java.awt.Color;
import javax.swing.JLabel;
import philosophers.Coordinator;

public class Philosopher
extends Thread {
    private JLabel label;
    private int firstChopstick;
    private int secondChopstick;
    private static final Color HUNGRY_COLOR = Color.RED;
    private static final Color EATING_COLOR = Color.GREEN;
    private static final Color THINKING_COLOR = Color.BLUE;
    private static final Color DEAD_COLOR = Color.BLACK;
    private boolean dead;
    private static final int AVERAGE_EAT_TIME = 5000;
    private static final int AVERAGE_THINK_TIME = 5000;

    public Philosopher(JLabel label, int firstChopstick, int secondChopstick) {
        this.label = label;
        this.firstChopstick = firstChopstick;
        this.secondChopstick = secondChopstick;
        this.dead = false;
    }

    @Override
    public void run() {
        while (!this.dead) {
            this.label.setForeground(HUNGRY_COLOR);
            this.label.repaint();
            new Message("U" + (char)this.firstChopstick).sendAwaitReply(Coordinator.getInstance());
            new Message("U" + (char)this.secondChopstick).sendAwaitReply(Coordinator.getInstance());
            this.label.setForeground(EATING_COLOR);
            this.label.repaint();
            try {
                Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            new Message("D" + (char)this.firstChopstick).send(Coordinator.getInstance());
            new Message("D" + (char)this.secondChopstick).send(Coordinator.getInstance());
            this.label.setForeground(THINKING_COLOR);
            this.label.repaint();
            try {
                Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
            }
            catch (InterruptedException interruptedException) {}
        }
        this.label.setForeground(DEAD_COLOR);
        this.label.repaint();
    }

    public void kill() {
        this.dead = true;
        this.interrupt();
    }

    public String name() {
        return this.label.getText();
    }
}

