/*
 * Decompiled with CFR 0.152.
 */
package philosophers;

import concurrency.BinarySemaphoreWithFIFOQueue;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import philosophers.Philosopher;

public class DiningRoom
extends JFrame {
    private static final int OVERALL_WIDTH = 650;
    private static final int OVERALL_HEIGHT = 350;
    private static final int NUMBER_OF_PHILOSOPHERS = 5;
    private static final int CHOPSTICK_WIDTH = 100;
    private static final int CHOPSTICK_HEIGHT = 20;
    private static final int[] CHOPSTICK_X = new int[]{150, 350, 425, 250, 75};
    private static final int[] CHOPSTICK_Y = new int[]{120, 120, 220, 270, 220};
    private static final String[] PHILOSOPHER_NAME = new String[]{"SOCRATES", "PLATO", "NIETZSCHE", "MARX", "HEGEL"};
    private static final int PHILOSOPHER_WIDTH = 150;
    private static final int PHILOSOPHER_HEIGHT = 50;
    private static final int[] PHILOSOPHER_X = new int[]{250, 450, 400, 100, 50};
    private static final int[] PHILOSOPHER_Y = new int[]{50, 150, 250, 250, 150};
    private Philosopher[] philosopher;

    public static void main(String[] args) {
        new DiningRoom();
    }

    public DiningRoom() {
        super("Dining Philosophers");
        int i;
        this.getContentPane().setLayout(null);
        this.setSize(650, 350);
        BinarySemaphoreWithFIFOQueue[] chopstick = new BinarySemaphoreWithFIFOQueue[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            chopstick[i2] = new BinarySemaphoreWithFIFOQueue();
        }
        JLabel[] philosopherRepresentation = new JLabel[5];
        for (i = 0; i < 5; ++i) {
            philosopherRepresentation[i] = new JLabel(PHILOSOPHER_NAME[i], 0);
            philosopherRepresentation[i].setFont(new Font("SansSerif", 0, 24));
            this.getContentPane().add(philosopherRepresentation[i]);
            philosopherRepresentation[i].setSize(150, 50);
            philosopherRepresentation[i].setLocation(PHILOSOPHER_X[i], PHILOSOPHER_Y[i]);
            philosopherRepresentation[i].setForeground(Color.white);
            final int philosopherNumber = i;
            philosopherRepresentation[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DiningRoom.this.philosopher[philosopherNumber].kill();
                }
            });
        }
        this.philosopher = new Philosopher[5];
        for (i = 0; i < 4; ++i) {
            this.philosopher[i] = new Philosopher(philosopherRepresentation[i], chopstick[i], chopstick[i + 1]);
        }
        this.philosopher[4] = new Philosopher(philosopherRepresentation[4], chopstick[0], chopstick[4]);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DiningRoom.this.setVisible(false);
                DiningRoom.this.dispose();
                System.exit(0);
            }
        });
        this.setVisible(true);
        for (i = 0; i < 5; ++i) {
            this.philosopher[i].start();
        }
    }
}

