/*
 * Decompiled with CFR 0.152.
 */
package diningphilosophers;

import diningphilosophers.ParametersDialog;
import diningphilosophers.Philosopher;
import diningphilosophers.PhilosopherDisplay;
import java.awt.EventQueue;
import java.awt.Rectangle;
import javax.swing.JOptionPane;

public class Main {
    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    SocketType socketType;
                    if (args.length > 0) {
                        socketType = SocketType.valueOf(SocketType.class, args[0]);
                    } else {
                        int choice = JOptionPane.showOptionDialog(null, "Socket Type", "Choose Socket Type", -1, 3, null, (Object[])SocketType.values(), null);
                        if (choice < 0) {
                            System.exit(0);
                        }
                        socketType = SocketType.values()[choice];
                    }
                    ParametersDialog parametersDialog = new ParametersDialog(null, true, args.length == 0);
                    parametersDialog.requestParameters();
                    Philosopher mainPhilosopher = new Philosopher(parametersDialog.getPhilosopherName(), parametersDialog.getLeftNeighbor(), parametersDialog.getRightNeighbor(), parametersDialog.getPickupLeftFirst(), socketType);
                    new PhilosopherDisplay(mainPhilosopher).setVisible(true);
                    mainPhilosopher.startLiving();
                    if (parametersDialog.isSingleSystem()) {
                        Philosopher.SecondPhilosopher secondPhilosopher = new Philosopher.SecondPhilosopher("Test2", parametersDialog.getLeftNeighbor(), parametersDialog.getRightNeighbor(), !parametersDialog.getPickupLeftFirst(), socketType);
                        PhilosopherDisplay secondDisplay = new PhilosopherDisplay(secondPhilosopher);
                        secondDisplay.setVisible(true);
                        Rectangle displayBounds = secondDisplay.getBounds();
                        displayBounds.x += displayBounds.width;
                        secondDisplay.setBounds(displayBounds);
                        secondPhilosopher.startLiving();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e);
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SocketType {
        TCP,
        UDP;

    }
}

