/*
 * Decompiled with CFR 0.152.
 */
package diningphilosophers;

import diningphilosophers.Chopstick;
import diningphilosophers.Main;
import diningphilosophers.TCPChopstick;
import diningphilosophers.UDPChopstick;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Observable;
import java.util.Observer;

public class Philosopher
extends Observable
implements Observer {
    private String philosopherName;
    private InetAddress leftNeighbor;
    private InetAddress rightNeighbor;
    private boolean pickupLeftFirst;
    private Chopstick leftChopstick;
    private Chopstick rightChopstick;
    private State state;
    public static final int AVERAGE_EAT_TIME = 5000;
    public static final int AVERAGE_THINK_TIME = 5000;

    public Philosopher(String philosopherName, InetAddress leftNeighbor, InetAddress rightNeighbor, boolean pickupLeftFirst, Main.SocketType socketType) throws IOException {
        this.philosopherName = philosopherName;
        this.leftNeighbor = leftNeighbor;
        this.rightNeighbor = rightNeighbor;
        this.pickupLeftFirst = pickupLeftFirst;
        switch (socketType) {
            case UDP: {
                this.leftChopstick = new UDPChopstick(this, true, leftNeighbor);
                this.rightChopstick = new UDPChopstick(this, false, rightNeighbor);
                break;
            }
            case TCP: {
                this.leftChopstick = new TCPChopstick(this, true, leftNeighbor);
                this.rightChopstick = new TCPChopstick(this, false, rightNeighbor);
            }
        }
        this.leftChopstick.addObserver(this);
        this.rightChopstick.addObserver(this);
        this.state = State.HUNGRY;
    }

    public String getPhilosopherName() {
        return this.philosopherName;
    }

    public InetAddress getLeftNeighbor() {
        return this.leftNeighbor;
    }

    public InetAddress getRightNeighbor() {
        return this.rightNeighbor;
    }

    public State getState() {
        return this.state;
    }

    public void startLiving() {
        new Thread(){

            public void run() {
                Philosopher.this.live();
            }
        }.start();
    }

    private void live() {
        while (true) {
            switch (this.state) {
                case HUNGRY: {
                    if (this.pickupLeftFirst) {
                        this.leftChopstick.pickup();
                        this.rightChopstick.pickup();
                    } else {
                        this.rightChopstick.pickup();
                        this.leftChopstick.pickup();
                    }
                    this.state = State.EATING;
                    this.setChanged();
                    this.notifyObservers((Object)Change.STATE_CHANGED);
                    break;
                }
                case EATING: {
                    try {
                        Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.state = State.SATED;
                    this.setChanged();
                    this.notifyObservers((Object)Change.STATE_CHANGED);
                    break;
                }
                case SATED: {
                    this.leftChopstick.putdown();
                    this.rightChopstick.putdown();
                    this.state = State.THINKING;
                    this.setChanged();
                    this.notifyObservers((Object)Change.STATE_CHANGED);
                    break;
                }
                case THINKING: {
                    try {
                        Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.state = State.HUNGRY;
                    this.setChanged();
                    this.notifyObservers((Object)Change.STATE_CHANGED);
                }
            }
        }
    }

    public void leaveDiningRoom() {
        this.leftChopstick.transferOwnership(this.rightNeighbor);
        System.exit(0);
    }

    public void update(Observable observable, Object arg) {
        switch ((Chopstick.Change)((Object)arg)) {
            case PICKED_UP: {
                this.setChanged();
                this.notifyObservers((Object)(observable == this.leftChopstick ? Change.LEFT_CHOPSTICK_PICKED_UP : Change.RIGHT_CHOPSTICK_PICKED_UP));
                break;
            }
            case PUT_DOWN: {
                this.setChanged();
                this.notifyObservers((Object)(observable == this.leftChopstick ? Change.LEFT_CHOPSTICK_PUT_DOWN : Change.RIGHT_CHOPSTICK_PUT_DOWN));
                break;
            }
            case NEIGHBOR_CHANGED: {
                this.setChanged();
                if (observable == this.leftChopstick) {
                    this.leftNeighbor = this.leftChopstick.getNeighbor();
                    this.notifyObservers((Object)Change.LEFT_NEIGHBOR_CHANGED);
                    break;
                }
                this.rightNeighbor = this.rightChopstick.getNeighbor();
                this.notifyObservers((Object)Change.RIGHT_NEIGHBOR_CHANGED);
            }
        }
    }

    public static class SecondPhilosopher
    extends Philosopher {
        public SecondPhilosopher(String philosopherName, InetAddress leftNeighbor, InetAddress rightNeighbor, boolean pickupLeftFirst, Main.SocketType socketType) throws IOException {
            super(philosopherName, leftNeighbor, rightNeighbor, pickupLeftFirst, socketType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Change {
        STATE_CHANGED,
        LEFT_CHOPSTICK_PICKED_UP,
        RIGHT_CHOPSTICK_PICKED_UP,
        LEFT_CHOPSTICK_PUT_DOWN,
        RIGHT_CHOPSTICK_PUT_DOWN,
        LEFT_NEIGHBOR_CHANGED,
        RIGHT_NEIGHBOR_CHANGED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        HUNGRY,
        EATING,
        SATED,
        THINKING;

    }
}

