/*
 * Decompiled with CFR 0.152.
 */
package diningphilosophers;

import diningphilosophers.Philosopher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PhilosopherDisplay
extends JFrame
implements Observer {
    private JPanel buttonPanel;
    private JPanel chopstickPanel;
    private JButton leaveButton;
    private JLabel leftChopstickStatus;
    private JLabel leftNeighborDescription;
    private JPanel neighborInfoPanel;
    private JLabel rightChopstickStatus;
    private JLabel rightNeighborDescription;
    private JLabel stateLabel;
    private JLabel thisNodeLabel;
    private Philosopher philosopher;
    private static final int DISPLAY_WIDTH = 600;
    private static final int DISPLAY_HEIGHT = 400;
    private static final Color HUNGRY_COLOR = Color.RED;
    private static final Color EATING_COLOR = Color.GREEN;
    private static final Color SATED_COLOR = Color.YELLOW;
    private static final Color THINKING_COLOR = Color.BLUE;

    public PhilosopherDisplay(Philosopher philosopher) {
        this.initComponents();
        this.philosopher = philosopher;
        philosopher.addObserver(this);
        try {
            this.thisNodeLabel.setText("" + InetAddress.getLocalHost());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.stateLabel.setText(philosopher.getPhilosopherName());
        this.update(philosopher, (Object)Philosopher.Change.STATE_CHANGED);
        if (philosopher.getLeftNeighbor() != null) {
            this.leftNeighborDescription.setText(philosopher.getLeftNeighbor().toString());
        }
        if (philosopher.getRightNeighbor() != null) {
            this.rightNeighborDescription.setText(philosopher.getRightNeighbor().toString());
        }
        this.setSize(600, 400);
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.chopstickPanel = new JPanel();
        this.leftChopstickStatus = new JLabel();
        this.rightChopstickStatus = new JLabel();
        this.neighborInfoPanel = new JPanel();
        this.leftNeighborDescription = new JLabel();
        this.rightNeighborDescription = new JLabel();
        this.buttonPanel = new JPanel();
        this.leaveButton = new JButton();
        this.thisNodeLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.stateLabel.setFont(new Font("Lucida Grande", 0, 144));
        this.stateLabel.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.getContentPane().add((Component)this.stateLabel, gridBagConstraints);
        this.chopstickPanel.setLayout(new GridBagLayout());
        this.leftChopstickStatus.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 20);
        this.chopstickPanel.add((Component)this.leftChopstickStatus, gridBagConstraints);
        this.rightChopstickStatus.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.chopstickPanel.add((Component)this.rightChopstickStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.getContentPane().add((Component)this.chopstickPanel, gridBagConstraints);
        this.neighborInfoPanel.setLayout(new GridBagLayout());
        this.leftNeighborDescription.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 20);
        this.neighborInfoPanel.add((Component)this.leftNeighborDescription, gridBagConstraints);
        this.rightNeighborDescription.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.neighborInfoPanel.add((Component)this.rightNeighborDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.getContentPane().add((Component)this.neighborInfoPanel, gridBagConstraints);
        this.leaveButton.setText("Leave Dining Room");
        this.leaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PhilosopherDisplay.this.leaveButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.leaveButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.thisNodeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 15, 5, 15);
        this.getContentPane().add((Component)this.thisNodeLabel, gridBagConstraints);
        this.pack();
    }

    private void leaveButtonActionPerformed(ActionEvent evt) {
        this.philosopher.leaveDiningRoom();
    }

    public void update(Observable observable, Object arg) {
        switch ((Philosopher.Change)((Object)arg)) {
            case STATE_CHANGED: {
                switch (this.philosopher.getState()) {
                    case HUNGRY: {
                        this.stateLabel.setForeground(HUNGRY_COLOR);
                        break;
                    }
                    case EATING: {
                        this.stateLabel.setForeground(EATING_COLOR);
                        break;
                    }
                    case SATED: {
                        this.stateLabel.setForeground(SATED_COLOR);
                        break;
                    }
                    case THINKING: {
                        this.stateLabel.setForeground(THINKING_COLOR);
                    }
                }
                this.stateLabel.repaint();
                break;
            }
            case LEFT_CHOPSTICK_PICKED_UP: {
                this.leftChopstickStatus.setText("Using");
                break;
            }
            case RIGHT_CHOPSTICK_PICKED_UP: {
                this.rightChopstickStatus.setText("Using");
                break;
            }
            case LEFT_CHOPSTICK_PUT_DOWN: {
                this.leftChopstickStatus.setText("");
                break;
            }
            case RIGHT_CHOPSTICK_PUT_DOWN: {
                this.rightChopstickStatus.setText("");
                break;
            }
            case LEFT_NEIGHBOR_CHANGED: {
                this.leftNeighborDescription.setText(this.philosopher.getLeftNeighbor().toString());
                break;
            }
            case RIGHT_NEIGHBOR_CHANGED: {
                this.rightNeighborDescription.setText(this.philosopher.getRightNeighbor().toString());
            }
        }
    }
}

