/*
 * Decompiled with CFR 0.152.
 */
package diningphilosophers;

import diningphilosophers.Chopstick;
import diningphilosophers.Philosopher;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Observable;

public class TCPChopstick
extends Observable
implements Chopstick {
    private boolean isLeft;
    private int listenForConnectionPort;
    private int initiateConnectionPort;
    private Socket neighborSocket;
    private int requestState;
    private static final int THIS_PHILOSOPHER_IS_NOT_REQUESTING = 0;
    private static final int THIS_PHILOSOPHER_IS_REQUESTING = 1;
    private static final int THIS_PHILOSOPHER_IS_USING = 2;
    private static final char REQUEST_CODE = 'R';
    private static final byte[] REQUEST_MESSAGE = new byte[]{82};
    private static final byte GRANT_CODE = 71;
    private static final byte[] GRANT_MESSAGE = new byte[]{71};
    private static final byte TRANSFER_CODE = 84;
    private static final int CHOPSTICK_REQUEST_TIMEOUT = 1000;

    public TCPChopstick(Philosopher philosopher, boolean isLeft, InetAddress neighbor) throws IOException {
        this.isLeft = isLeft;
        if (neighbor == null || !neighbor.isLoopbackAddress()) {
            this.listenForConnectionPort = isLeft ? 42420 : 42421;
            this.initiateConnectionPort = isLeft ? 42421 : 42420;
        } else if (philosopher instanceof Philosopher.SecondPhilosopher) {
            this.listenForConnectionPort = isLeft ? 42422 : 42423;
            this.initiateConnectionPort = isLeft ? 42421 : 42420;
        } else {
            this.listenForConnectionPort = isLeft ? 42420 : 42421;
            neighbor = null;
        }
        new Thread(){

            public void run() {
                TCPChopstick.this.listenForConnections();
            }
        }.start();
        if (neighbor != null) {
            this.neighborSocket = new Socket(neighbor, this.initiateConnectionPort);
        }
        this.requestState = 0;
        new Thread(){

            public void run() {
                TCPChopstick.this.listenForMessages();
            }
        }.start();
    }

    public InetAddress getNeighbor() {
        return this.neighborSocket.getInetAddress();
    }

    public synchronized void pickup() {
        while (this.requestState != 2) {
            this.sendMessage(REQUEST_MESSAGE);
            this.requestState = 1;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setChanged();
        this.notifyObservers((Object)Chopstick.Change.PICKED_UP);
    }

    public synchronized void putdown() {
        this.requestState = 0;
        this.setChanged();
        this.notifyObservers((Object)Chopstick.Change.PUT_DOWN);
    }

    public void transferOwnership(InetAddress transferTo) {
        byte[] transferToIP = transferTo.getAddress();
        byte[] message = new byte[1 + transferToIP.length];
        message[0] = 84;
        for (int i = 0; i < transferToIP.length; ++i) {
            message[i + 1] = transferToIP[i];
        }
        this.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listenForConnections() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.listenForConnectionPort);
            while (true) {
                Socket connectionSocket = serverSocket.accept();
                TCPChopstick tCPChopstick = this;
                synchronized (tCPChopstick) {
                    this.neighborSocket = connectionSocket;
                    this.setChanged();
                    this.notifyObservers((Object)Chopstick.Change.NEIGHBOR_CHANGED);
                    this.notifyAll();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Exception on server listen: " + e);
            System.exit(1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void listenForMessages() {
        byte[] messageBuffer = new byte[17];
        while (true) {
            int bytesRead = 0;
            try {
                while (this.neighborSocket == null) {
                    TCPChopstick tCPChopstick = this;
                    synchronized (tCPChopstick) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                this.neighborSocket.setSoTimeout(1000);
                bytesRead = this.neighborSocket.getInputStream().read(messageBuffer);
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                System.err.println("Exception in receive: " + e);
                System.exit(1);
            }
            if (bytesRead > 0) {
                // empty if block
            }
            if (bytesRead > 0) {
                byte code = messageBuffer[0];
                switch (code) {
                    case 82: {
                        if (this.requestState != 0 && (this.requestState != 1 || !this.isLeft)) break;
                        this.sendMessage(GRANT_MESSAGE);
                        break;
                    }
                    case 71: {
                        TCPChopstick e = this;
                        synchronized (e) {
                            if (this.requestState == 1) {
                                this.requestState = 2;
                                this.notify();
                            }
                            break;
                        }
                    }
                    case 84: {
                        try {
                            byte[] transferToAddress = new byte[bytesRead - 1];
                            for (int i = 0; i < transferToAddress.length; ++i) {
                                transferToAddress[i] = messageBuffer[i + 1];
                            }
                            InetAddress transferTo = InetAddress.getByAddress(transferToAddress);
                            TCPChopstick tCPChopstick = this;
                            synchronized (tCPChopstick) {
                                if (this.neighborSocket != null) {
                                    this.neighborSocket.close();
                                }
                                this.neighborSocket = new Socket(transferTo, this.initiateConnectionPort);
                                this.setChanged();
                                this.notifyObservers((Object)Chopstick.Change.NEIGHBOR_CHANGED);
                            }
                        }
                        catch (IOException e) {
                            System.err.println("Exception in transfer: " + e);
                            System.exit(1);
                        }
                        break;
                    }
                }
            }
            if (this.requestState != 1) continue;
            this.sendMessage(REQUEST_MESSAGE);
        }
    }

    private synchronized void sendMessage(byte[] message) {
        while (this.neighborSocket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        try {
            this.neighborSocket.getOutputStream().write(message);
        }
        catch (IOException e) {
            System.err.println("Exception in send: " + e);
            System.exit(1);
        }
    }
}

