/*
 * Decompiled with CFR 0.152.
 */
package diningphilosophers;

import diningphilosophers.Chopstick;
import diningphilosophers.Philosopher;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Observable;

public class UDPChopstick
extends Observable
implements Chopstick {
    private boolean isLeft;
    private InetAddress neighbor;
    private DatagramSocket socket;
    private DatagramPacket receivePacket;
    private DatagramPacket sendPacket;
    private int requestState;
    private static final int THIS_PHILOSOPHER_IS_NOT_REQUESTING = 0;
    private static final int THIS_PHILOSOPHER_IS_REQUESTING = 1;
    private static final int THIS_PHILOSOPHER_IS_USING = 2;
    private static final char REQUEST_CODE = 'R';
    private static final byte[] REQUEST_MESSAGE = new byte[]{82};
    private static final byte GRANT_CODE = 71;
    private static final byte[] GRANT_MESSAGE = new byte[]{71};
    private static final byte TRANSFER_CODE = 84;
    private static final int CHOPSTICK_REQUEST_TIMEOUT = 1000;

    public UDPChopstick(Philosopher philosopher, boolean isLeft, InetAddress neighbor) throws IOException {
        int sendPort;
        int listenPort;
        this.isLeft = isLeft;
        this.neighbor = neighbor;
        if (neighbor == null || !neighbor.isLoopbackAddress()) {
            listenPort = isLeft ? 42420 : 42421;
            sendPort = isLeft ? 42421 : 42420;
        } else if (philosopher instanceof Philosopher.SecondPhilosopher) {
            listenPort = isLeft ? 42422 : 42423;
            sendPort = isLeft ? 42421 : 42420;
        } else {
            listenPort = isLeft ? 42420 : 42421;
            sendPort = isLeft ? 42423 : 42422;
        }
        this.socket = new DatagramSocket(listenPort);
        this.receivePacket = new DatagramPacket(new byte[17], 17);
        this.sendPacket = new DatagramPacket(new byte[17], 17, neighbor, sendPort);
        this.requestState = 0;
        new Thread(){

            public void run() {
                UDPChopstick.this.listenForMessages();
            }
        }.start();
    }

    public InetAddress getNeighbor() {
        return this.neighbor;
    }

    public synchronized void pickup() {
        while (this.requestState != 2) {
            this.sendMessage(REQUEST_MESSAGE);
            this.requestState = 1;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setChanged();
        this.notifyObservers((Object)Chopstick.Change.PICKED_UP);
    }

    public synchronized void putdown() {
        this.requestState = 0;
        this.setChanged();
        this.notifyObservers((Object)Chopstick.Change.PUT_DOWN);
    }

    public void transferOwnership(InetAddress transferTo) {
        byte[] transferToIP = transferTo.getAddress();
        byte[] message = new byte[1 + transferToIP.length];
        message[0] = 84;
        for (int i = 0; i < transferToIP.length; ++i) {
            message[i + 1] = transferToIP[i];
        }
        this.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void listenForMessages() {
        while (true) {
            boolean messageReceived = false;
            try {
                this.socket.setSoTimeout(1000);
                this.socket.receive(this.receivePacket);
                messageReceived = true;
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                System.err.println("Exception in receive: " + e);
                System.exit(1);
            }
            if (messageReceived) {
                // empty if block
            }
            if (messageReceived) {
                UDPChopstick uDPChopstick;
                InetAddress messageCameFrom = this.receivePacket.getAddress();
                byte code = this.receivePacket.getData()[0];
                if (messageCameFrom != this.neighbor) {
                    uDPChopstick = this;
                    synchronized (uDPChopstick) {
                        this.neighbor = messageCameFrom;
                        this.setChanged();
                        this.notifyObservers((Object)Chopstick.Change.NEIGHBOR_CHANGED);
                        this.notify();
                    }
                }
                switch (code) {
                    case 82: {
                        if (this.requestState != 0 && (this.requestState != 1 || !this.isLeft)) break;
                        this.sendMessage(GRANT_MESSAGE);
                        break;
                    }
                    case 71: {
                        uDPChopstick = this;
                        synchronized (uDPChopstick) {
                            if (this.requestState == 1) {
                                this.requestState = 2;
                                this.notify();
                            }
                            break;
                        }
                    }
                    case 84: {
                        try {
                            byte[] transferToAddress = new byte[this.receivePacket.getLength() - 1];
                            for (int i = 0; i < transferToAddress.length; ++i) {
                                transferToAddress[i] = this.receivePacket.getData()[i + 1];
                            }
                            InetAddress transferTo = InetAddress.getByAddress(transferToAddress);
                            UDPChopstick uDPChopstick2 = this;
                            synchronized (uDPChopstick2) {
                                this.neighbor = transferTo;
                                this.setChanged();
                                this.notifyObservers((Object)Chopstick.Change.NEIGHBOR_CHANGED);
                            }
                        }
                        catch (UnknownHostException e) {
                            System.err.println("Exception in transfer: " + e);
                            System.exit(1);
                        }
                        break;
                    }
                }
            }
            if (this.requestState != 1) continue;
            this.sendMessage(REQUEST_MESSAGE);
        }
    }

    private synchronized void sendMessage(byte[] message) {
        while (this.neighbor == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.sendPacket.setAddress(this.neighbor);
        this.sendPacket.setData(message);
        this.sendPacket.setLength(message.length);
        try {
            this.socket.send(this.sendPacket);
        }
        catch (IOException e) {
            System.err.println("Exception in send: " + e);
            System.exit(1);
        }
    }
}

