/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Observable;

public abstract class DistributedWave
extends Observable {
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final String[] SIDE_NAME = new String[]{"left", "right"};
    static final int[] COMMUNICATE_WITH_NEIGHBOR_PORT = new int[]{42420, 42421};
    static final int MESSAGE_LENGTH;
    private static final byte[] WAVE_STARTED_HERE_MESSAGE;
    static final int NUMBER_OF_STEPS = 13;
    private static final int TIME_PER_STEP = 200;
    private static final int STEPS_BEFORE_SIGNALLING_NEIGHBOR = 7;
    private volatile boolean propagateForever;

    public void startListeners() {
        new Thread(){

            public void run() {
                DistributedWave.this.listenForMessages(0);
            }
        }.start();
        new Thread(){

            public void run() {
                DistributedWave.this.listenForMessages(1);
            }
        }.start();
    }

    public synchronized void doWave(int startingSide, byte[] messageReceived) {
        for (int i = 0; i < 13; ++i) {
            this.setChanged();
            if (startingSide == 0) {
                this.notifyObservers(i);
            } else {
                this.notifyObservers(13 - i - 1);
            }
            if (i == 7) {
                byte[] messageToPropagate = messageReceived != null ? messageReceived : WAVE_STARTED_HERE_MESSAGE;
                this.sendToNeighbor(1 - startingSide, messageToPropagate);
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    void listenForMessages(int side) {
        byte[] messageReceived = null;
        while (true) {
            if (Arrays.equals(messageReceived = this.receiveMessage(side), WAVE_STARTED_HERE_MESSAGE) && !this.propagateForever) {
                continue;
            }
            this.doWave(side, messageReceived);
        }
    }

    public void setPropagateForever(boolean propagateForever) {
        this.propagateForever = propagateForever;
    }

    abstract void sendToNeighbor(int var1, byte[] var2);

    abstract byte[] receiveMessage(int var1);

    static {
        byte[] thisNodesIP = null;
        try {
            thisNodesIP = InetAddress.getLocalHost().getAddress();
        }
        catch (IOException e) {
            System.err.println("Error accessing IP for this host: " + e);
            System.exit(1);
        }
        MESSAGE_LENGTH = 1 + thisNodesIP.length;
        WAVE_STARTED_HERE_MESSAGE = new byte[MESSAGE_LENGTH];
        DistributedWave.WAVE_STARTED_HERE_MESSAGE[0] = 87;
        for (int i = 0; i < thisNodesIP.length; ++i) {
            DistributedWave.WAVE_STARTED_HERE_MESSAGE[i + 1] = thisNodesIP[i];
        }
    }
}

