/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class DistributedWaveTCP
extends DistributedWave {
    private Socket[] communicateWithNeighborSocket = new Socket[2];

    public DistributedWaveTCP(InetAddress leftNeighbor, InetAddress rightNeighbor) throws IOException {
        if (leftNeighbor != null) {
            this.communicateWithNeighborSocket[0] = new Socket();
            this.communicateWithNeighborSocket[0].connect(new InetSocketAddress(leftNeighbor, COMMUNICATE_WITH_NEIGHBOR_PORT[1]));
        } else {
            new Thread(){

                public void run() {
                    DistributedWaveTCP.this.listenForConnectionRequest(0);
                }
            }.start();
        }
        if (rightNeighbor != null) {
            this.communicateWithNeighborSocket[1] = new Socket();
            this.communicateWithNeighborSocket[1].connect(new InetSocketAddress(rightNeighbor, COMMUNICATE_WITH_NEIGHBOR_PORT[0]));
        } else {
            new Thread(){

                public void run() {
                    DistributedWaveTCP.this.listenForConnectionRequest(1);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenForConnectionRequest(int side) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(COMMUNICATE_WITH_NEIGHBOR_PORT[side]);
        }
        catch (IOException e) {
            System.err.println("Error creating server socket on " + SIDE_NAME[side] + " " + e);
            System.exit(1);
        }
        while (true) {
            Socket connectionSocket = null;
            try {
                connectionSocket = serverSocket.accept();
            }
            catch (IOException e) {
                System.err.println("Error accepting connection on " + SIDE_NAME[side] + " " + e);
                System.exit(1);
            }
            DistributedWaveTCP distributedWaveTCP = this;
            synchronized (distributedWaveTCP) {
                this.communicateWithNeighborSocket[side] = connectionSocket;
                this.notifyAll();
            }
        }
    }

    void sendToNeighbor(int side, byte[] waveMessage) {
        if (this.communicateWithNeighborSocket[side] != null) {
            try {
                this.communicateWithNeighborSocket[side].getOutputStream().write(waveMessage);
            }
            catch (IOException e) {
                System.err.println("Exception sending to neighbor on " + SIDE_NAME[1 - side] + ": " + e);
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] receiveMessage(int side) {
        byte[] messageBuffer = new byte[MESSAGE_LENGTH];
        while (this.communicateWithNeighborSocket[side] == null) {
            DistributedWaveTCP distributedWaveTCP = this;
            synchronized (distributedWaveTCP) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        try {
            this.communicateWithNeighborSocket[side].getInputStream().read(messageBuffer);
        }
        catch (IOException e) {
            System.err.println("Exception on receiving from neighbor on " + SIDE_NAME[side] + ": " + e);
            System.exit(1);
        }
        return messageBuffer;
    }
}

