/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class DistributedWaveUDP
extends DistributedWave {
    private InetAddress[] neighborAddress = new InetAddress[2];
    private DatagramSocket[] communicateWithNeighborSocket = new DatagramSocket[2];

    public DistributedWaveUDP(InetAddress leftNeighbor, InetAddress rightNeighbor) throws SocketException {
        this.neighborAddress[0] = leftNeighbor;
        this.neighborAddress[1] = rightNeighbor;
        this.communicateWithNeighborSocket[0] = new DatagramSocket(COMMUNICATE_WITH_NEIGHBOR_PORT[0]);
        this.communicateWithNeighborSocket[1] = new DatagramSocket(COMMUNICATE_WITH_NEIGHBOR_PORT[1]);
    }

    void sendToNeighbor(int side, byte[] waveMessage) {
        if (this.neighborAddress[side] != null) {
            DatagramPacket sendPacket = new DatagramPacket(waveMessage, waveMessage.length, this.neighborAddress[side], COMMUNICATE_WITH_NEIGHBOR_PORT[1 - side]);
            try {
                this.communicateWithNeighborSocket[side].send(sendPacket);
            }
            catch (IOException e) {
                System.err.println("Exception sending to neighbor on " + SIDE_NAME[side] + ": " + e);
                System.exit(1);
            }
        }
    }

    byte[] receiveMessage(int side) {
        DatagramPacket receivePacket = new DatagramPacket(new byte[MESSAGE_LENGTH], MESSAGE_LENGTH);
        try {
            this.communicateWithNeighborSocket[side].receive(receivePacket);
        }
        catch (IOException e) {
            System.err.println("Exception on receiving from neighbor on " + SIDE_NAME[side] + ": " + e);
            System.exit(1);
        }
        this.neighborAddress[side] = receivePacket.getAddress();
        return receivePacket.getData();
    }
}

