/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import distributedwave.DistributedWaveTCP;
import distributedwave.DistributedWaveUDP;
import distributedwave.MainFrame;
import distributedwave.ParametersDialog;
import java.awt.EventQueue;
import javax.swing.JOptionPane;

public class Main {
    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    DistributedWave wave;
                    SocketType socketType;
                    if (args.length > 0) {
                        socketType = SocketType.valueOf(SocketType.class, args[0]);
                    } else {
                        int choice = JOptionPane.showOptionDialog(null, "Socket Type", "Choose Socket Type", -1, 3, null, (Object[])SocketType.values(), null);
                        if (choice < 0) {
                            System.exit(0);
                        }
                        socketType = SocketType.values()[choice];
                    }
                    ParametersDialog parametersDialog = new ParametersDialog(null, true, args.length == 0);
                    parametersDialog.requestParameters();
                    switch (socketType) {
                        case UDP: {
                            wave = new DistributedWaveUDP(parametersDialog.getLeftNeighbor(), parametersDialog.getRightNeighbor());
                            break;
                        }
                        default: {
                            wave = new DistributedWaveTCP(parametersDialog.isSingleSystem() ? null : parametersDialog.getLeftNeighbor(), parametersDialog.getRightNeighbor());
                        }
                    }
                    new MainFrame(wave).setVisible(true);
                    wave.startListeners();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SocketType {
        TCP,
        UDP;

    }
}

