/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import distributedwave.WaveDisplay;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame {
    private JPanel buttonPanel;
    private JButton leftToRightButton;
    private JCheckBox propagateForeverCheckbox;
    private JPanel propagateForeverPanel;
    private JButton rightToLeftButton;
    private JPanel wavePanel;
    private DistributedWave wave;

    public MainFrame(DistributedWave wave) {
        this.wave = wave;
        this.initComponents();
        this.wavePanel.add(new WaveDisplay(wave));
        this.propagateForeverCheckboxStateChanged(null);
        this.pack();
    }

    private void initComponents() {
        this.wavePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.leftToRightButton = new JButton();
        this.rightToLeftButton = new JButton();
        this.propagateForeverPanel = new JPanel();
        this.propagateForeverCheckbox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 15, 5, 15);
        this.getContentPane().add((Component)this.wavePanel, gridBagConstraints);
        this.leftToRightButton.setText("Start Left to Right Wave");
        this.leftToRightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.leftToRightButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.leftToRightButton);
        this.rightToLeftButton.setText("Start Right to Left Wave");
        this.rightToLeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.rightToLeftButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.rightToLeftButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.propagateForeverCheckbox.setText("Keep propagating a wave forever");
        this.propagateForeverCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.propagateForeverCheckboxStateChanged(evt);
            }
        });
        this.propagateForeverPanel.add(this.propagateForeverCheckbox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        this.getContentPane().add((Component)this.propagateForeverPanel, gridBagConstraints);
        this.pack();
    }

    private void leftToRightButtonActionPerformed(ActionEvent evt) {
        new Thread(){

            public void run() {
                MainFrame.this.wave.doWave(0, null);
            }
        }.start();
    }

    private void rightToLeftButtonActionPerformed(ActionEvent evt) {
        new Thread(){

            public void run() {
                MainFrame.this.wave.doWave(1, null);
            }
        }.start();
    }

    private void propagateForeverCheckboxStateChanged(ChangeEvent evt) {
        this.wave.setPropagateForever(this.propagateForeverCheckbox.isSelected());
    }
}

