/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Observable;

public class DistributedWaveTCP
extends Observable
implements DistributedWave {
    private Socket leftNeighborSocket;
    private Socket rightNeighborSocket;
    private volatile boolean propagateForever;
    private static final byte[] LEFT_CONNECT_MESSAGE = new byte[]{76};
    private static final byte[] RIGHT_CONNECT_MESSAGE = new byte[]{82};
    private static byte[] waveStartedHereMessage;

    public DistributedWaveTCP(InetAddress leftNeighbor, InetAddress rightNeighbor, boolean isSingleSystem) throws IOException {
        new Thread(){

            public void run() {
                DistributedWaveTCP.this.listenForConnections(true);
            }
        }.start();
        new Thread(){

            public void run() {
                DistributedWaveTCP.this.listenForConnections(false);
            }
        }.start();
        byte[] thisNodesIP = InetAddress.getLocalHost().getAddress();
        waveStartedHereMessage = new byte[17];
        DistributedWaveTCP.waveStartedHereMessage[0] = 87;
        for (int i = 0; i < thisNodesIP.length; ++i) {
            DistributedWaveTCP.waveStartedHereMessage[i + 1] = thisNodesIP[i];
        }
        if (leftNeighbor != null) {
            this.leftNeighborSocket = new Socket(leftNeighbor, 42421);
        }
        if (rightNeighbor != null && !isSingleSystem) {
            this.rightNeighborSocket = new Socket(rightNeighbor, 42420);
        }
        new Thread(){

            public void run() {
                DistributedWaveTCP.this.listenForMessages(true);
            }
        }.start();
        new Thread(){

            public void run() {
                DistributedWaveTCP.this.listenForMessages(false);
            }
        }.start();
    }

    public synchronized void doWave(boolean leftToRight, byte[] messageReceived) {
        for (int i = 0; i < 13; ++i) {
            this.setChanged();
            this.notifyObservers(new Integer(leftToRight ? 13 - i - 1 : i));
            if (i == 7) {
                Socket propagateSocket = leftToRight ? this.rightNeighborSocket : this.leftNeighborSocket;
                try {
                    if (propagateSocket != null) {
                        if (messageReceived == null) {
                            propagateSocket.getOutputStream().write(waveStartedHereMessage);
                        } else {
                            propagateSocket.getOutputStream().write(messageReceived);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception on send to " + (leftToRight ? "right" : "left") + ": " + e);
                    System.exit(1);
                }
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listenForConnections(boolean fromLeft) {
        try {
            ServerSocket serverSocket = new ServerSocket(fromLeft ? 42420 : 42421);
            while (true) {
                Socket connectionSocket = serverSocket.accept();
                DistributedWaveTCP distributedWaveTCP = this;
                synchronized (distributedWaveTCP) {
                    if (fromLeft) {
                        this.leftNeighborSocket = connectionSocket;
                    } else {
                        this.rightNeighborSocket = connectionSocket;
                    }
                    this.notifyAll();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Exception on server listen: " + e);
            System.exit(1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenForMessages(boolean fromLeft) {
        byte[] messageBuffer = new byte[17];
        while (true) {
            Socket receiveSocket = fromLeft ? this.leftNeighborSocket : this.rightNeighborSocket;
            try {
                while (receiveSocket == null) {
                    DistributedWaveTCP distributedWaveTCP = this;
                    synchronized (distributedWaveTCP) {
                        try {
                            this.wait();
                            receiveSocket = fromLeft ? this.leftNeighborSocket : this.rightNeighborSocket;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                int messageLength = receiveSocket.getInputStream().read(messageBuffer);
                if (messageLength <= 0 || Arrays.equals(messageBuffer, waveStartedHereMessage) && !this.propagateForever) continue;
                this.doWave(fromLeft, messageBuffer);
                continue;
            }
            catch (IOException e) {
                System.err.println("Exception on receive from " + (fromLeft ? "left" : "right") + ": " + e);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public void setPropagateForever(boolean propagateForever) {
        this.propagateForever = propagateForever;
    }
}

