/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Observable;

public class DistributedWaveUDP
extends Observable
implements DistributedWave {
    private DatagramSocket leftNeighborSocket;
    private DatagramSocket rightNeighborSocket;
    private DatagramPacket sendLeftPacket;
    private DatagramPacket sendRightPacket;
    private DatagramPacket receiveFromLeftPacket;
    private DatagramPacket receiveFromRightPacket;
    private volatile boolean propagateForever;
    private byte[] waveStartedHereMessage;

    public DistributedWaveUDP(InetAddress leftNeighbor, InetAddress rightNeighbor, boolean isSingleSystem) throws SocketException, UnknownHostException {
        byte[] thisNodesIP = InetAddress.getLocalHost().getAddress();
        this.waveStartedHereMessage = new byte[17];
        this.waveStartedHereMessage[0] = 87;
        for (int i = 0; i < thisNodesIP.length; ++i) {
            this.waveStartedHereMessage[i + 1] = thisNodesIP[i];
        }
        this.leftNeighborSocket = new DatagramSocket(42420);
        this.rightNeighborSocket = new DatagramSocket(42421);
        this.sendLeftPacket = new DatagramPacket(new byte[17], 17, leftNeighbor, 42421);
        this.sendRightPacket = new DatagramPacket(new byte[17], 17, rightNeighbor, 42420);
        this.receiveFromLeftPacket = new DatagramPacket(new byte[17], 17);
        this.receiveFromRightPacket = new DatagramPacket(new byte[17], 17);
        new Thread(){

            public void run() {
                DistributedWaveUDP.this.listenForMessages(true);
            }
        }.start();
        new Thread(){

            public void run() {
                DistributedWaveUDP.this.listenForMessages(false);
            }
        }.start();
    }

    public synchronized void doWave(boolean leftToRight, byte[] messageReceived) {
        DatagramSocket propagateSocket = leftToRight ? this.rightNeighborSocket : this.leftNeighborSocket;
        DatagramPacket propagatePacket = leftToRight ? this.sendRightPacket : this.sendLeftPacket;
        for (int i = 0; i < 13; ++i) {
            this.setChanged();
            this.notifyObservers(new Integer(leftToRight ? 13 - i - 1 : i));
            if (i == 7) {
                try {
                    if (propagatePacket.getAddress() != null) {
                        if (messageReceived == null) {
                            propagatePacket.setData(this.waveStartedHereMessage);
                            propagatePacket.setLength(this.waveStartedHereMessage.length);
                            propagateSocket.send(propagatePacket);
                        } else {
                            propagatePacket.setData(messageReceived);
                            propagatePacket.setLength(messageReceived.length);
                            propagateSocket.send(propagatePacket);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception on send to " + (leftToRight ? "right" : "left") + ": " + e);
                    System.exit(1);
                }
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void listenForMessages(boolean fromLeft) {
        DatagramPacket receivePacket = fromLeft ? this.receiveFromLeftPacket : this.receiveFromRightPacket;
        while (true) {
            DatagramSocket receiveSocket = fromLeft ? this.leftNeighborSocket : this.rightNeighborSocket;
            try {
                receiveSocket.receive(receivePacket);
                InetAddress messageCameFrom = receivePacket.getAddress();
                if (fromLeft) {
                    this.sendLeftPacket.setAddress(messageCameFrom);
                } else {
                    this.sendRightPacket.setAddress(messageCameFrom);
                }
                if (Arrays.equals(receivePacket.getData(), this.waveStartedHereMessage) && !this.propagateForever) continue;
                this.doWave(fromLeft, receivePacket.getData());
                continue;
            }
            catch (IOException e) {
                System.err.println("Exception on receive from " + (fromLeft ? "left" : "right") + ": " + e);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public void setPropagateForever(boolean propagateForever) {
        this.propagateForever = propagateForever;
    }
}

