/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParametersDialog
extends JDialog
implements ActionListener {
    private JPanel buttonPanel;
    private JTextField leftNeighborField;
    private JLabel leftNeighborLabel;
    private JPanel neighborPanel;
    private JButton okButton;
    private ButtonGroup orderGroup;
    private ButtonGroup partGroup;
    private JTextField rightNeighborField;
    private JLabel rightNeighborLabel;
    private JCheckBox singleSystemCheckBox;
    private InetAddress leftNeighbor;
    private InetAddress rightNeighbor;

    public ParametersDialog(Frame parent, boolean modal, boolean offerSingleSystem) {
        super(parent, modal);
        this.initComponents();
        if (!offerSingleSystem) {
            this.singleSystemCheckBox.setVisible(false);
            this.pack();
        }
        this.leftNeighborField.addActionListener(this);
        this.rightNeighborField.addActionListener(this);
    }

    private void initComponents() {
        this.orderGroup = new ButtonGroup();
        this.partGroup = new ButtonGroup();
        this.neighborPanel = new JPanel();
        this.leftNeighborLabel = new JLabel();
        this.leftNeighborField = new JTextField();
        this.rightNeighborLabel = new JLabel();
        this.rightNeighborField = new JTextField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.singleSystemCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.neighborPanel.setBorder(BorderFactory.createTitledBorder("Neighbors"));
        this.neighborPanel.setLayout(new GridBagLayout());
        this.leftNeighborLabel.setText("Left");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.neighborPanel.add((Component)this.leftNeighborLabel, gridBagConstraints);
        this.leftNeighborField.setColumns(30);
        this.leftNeighborField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                ParametersDialog.this.leftNeighborFieldCaretUpdate(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 70;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.neighborPanel.add((Component)this.leftNeighborField, gridBagConstraints);
        this.rightNeighborLabel.setText("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.neighborPanel.add((Component)this.rightNeighborLabel, gridBagConstraints);
        this.rightNeighborField.setColumns(30);
        this.rightNeighborField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                ParametersDialog.this.rightNeighborFieldCaretUpdate(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 70;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.neighborPanel.add((Component)this.rightNeighborField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 5, 15);
        this.getContentPane().add((Component)this.neighborPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.singleSystemCheckBox.setText("Test with Single System");
        this.singleSystemCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ParametersDialog.this.singleSystemCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.getContentPane().add((Component)this.singleSystemCheckBox, gridBagConstraints);
        this.pack();
    }

    void requestParameters() {
        boolean ok;
        do {
            ok = true;
            this.setVisible(true);
            try {
                this.leftNeighbor = this.leftNeighborField.getText().length() == 0 ? null : InetAddress.getByName(this.leftNeighborField.getText());
            }
            catch (UnknownHostException e) {
                JOptionPane.showMessageDialog(this, "Incorrect format address or network problem " + this.leftNeighborField.getText());
                ok = false;
            }
            if (!ok) continue;
            try {
                if (this.rightNeighborField.getText().length() == 0) {
                    this.rightNeighbor = null;
                    continue;
                }
                this.rightNeighbor = InetAddress.getByName(this.rightNeighborField.getText());
            }
            catch (UnknownHostException e) {
                JOptionPane.showMessageDialog(this, "Incorrect format address or network problem " + this.rightNeighborField.getText());
                ok = false;
            }
        } while (!ok);
    }

    InetAddress getLeftNeighbor() {
        return this.leftNeighbor;
    }

    InetAddress getRightNeighbor() {
        return this.rightNeighbor;
    }

    boolean isSingleSystem() {
        return this.singleSystemCheckBox.isSelected();
    }

    public void actionPerformed(ActionEvent evt) {
        this.okButtonActionPerformed(evt);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        System.exit(0);
    }

    private void singleSystemCheckBoxStateChanged(ChangeEvent evt) {
        if (this.singleSystemCheckBox.isSelected()) {
            this.leftNeighborField.setEditable(false);
            this.rightNeighborField.setEditable(false);
            this.leftNeighborField.setText("localhost");
            this.rightNeighborField.setText("localhost");
        } else {
            this.leftNeighborField.setEditable(true);
            this.rightNeighborField.setEditable(true);
            this.leftNeighborField.setText("");
            this.rightNeighborField.setText("");
        }
    }

    private void leftNeighborFieldCaretUpdate(CaretEvent evt) {
        if (this.leftNeighborField.getText().equals("localhost") && !this.singleSystemCheckBox.isSelected()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ParametersDialog.this.singleSystemCheckBox.setSelected(true);
                }
            });
        }
    }

    private void rightNeighborFieldCaretUpdate(CaretEvent evt) {
        if (this.rightNeighborField.getText().equals("localhost") && !this.singleSystemCheckBox.isSelected()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ParametersDialog.this.singleSystemCheckBox.setSelected(true);
                }
            });
        }
    }
}

