/*
 * Decompiled with CFR 0.152.
 */
package distributedwave;

import distributedwave.DistributedWave;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class WaveDisplay
extends JComponent
implements Observer {
    private Image[] images;
    private Image currentImage;
    private static final int PREFERRED_WIDTH = 800;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaveDisplay(DistributedWave wave) {
        wave.addObserver(this);
        this.images = new Image[13];
        int height = -1;
        for (int i = 0; i < 13; ++i) {
            this.images[i] = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("images/wave" + i + ".png")).getScaledInstance(800, -1, 1);
            height = this.images[i].getHeight(this);
            while (height < 0) {
                WaveDisplay waveDisplay = this;
                synchronized (waveDisplay) {
                    try {
                        this.wait();
                        height = this.images[i].getHeight(this);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.currentImage = this.images[0];
        this.setPreferredSize(new Dimension(800, height));
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.currentImage, 0, 0, this);
    }

    public void update(Observable observable, Object arg) {
        this.currentImage = this.images[(Integer)arg];
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            WaveDisplay waveDisplay = this;
            synchronized (waveDisplay) {
                this.notify();
                return false;
            }
        }
        return true;
    }
}

