/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public abstract class RealmBase
implements Lifecycle,
Realm,
MBeanRegistration {
    private static Log log = LogFactory.getLog((Class)RealmBase.class);
    protected Container container = null;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static MessageDigest md5Helper;
    protected static StringManager sm;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected String type;
    protected String domain;
    protected String host;
    protected String path;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;
    protected boolean initialized = false;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Principal authenticate(String username, String credentials) {
        String serverCredentials = this.getPassword(username);
        boolean validated = serverCredentials == null ? false : (this.hasMessageDigest() ? serverCredentials.equalsIgnoreCase(this.digest(credentials)) : serverCredentials.equals(credentials));
        if (!validated) {
            if (this.container.getLogger().isTraceEnabled()) {
                this.container.getLogger().trace((Object)sm.getString("realmBase.authenticateFailure", username));
            }
            return null;
        }
        if (this.container.getLogger().isTraceEnabled()) {
            this.container.getLogger().trace((Object)sm.getString("realmBase.authenticateSuccess", username));
        }
        return this.getPrincipal(username);
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, credentials.toString());
    }

    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        String serverDigestValue = md5a1 + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = serverDigestValue.getBytes();
        } else {
            try {
                valueBytes = serverDigestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        String serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + clientDigest + " Username:" + username + " ClientSigest:" + clientDigest + " nOnce:" + nOnce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + md5a2 + " Server digest:" + serverDigest));
        }
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < certs.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + certs[i].getSubjectDN().getName() + "'"));
                }
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)e);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0].getSubjectDN().getName());
    }

    public void backgroundProcess() {
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        String pattern;
        int k;
        boolean matched;
        int i;
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getRequestPathMB().toString();
        String method = request.getMethod();
        boolean found = false;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (int k2 = 0; k2 < patterns.length; ++k2) {
                    if (!uri.equals(patterns[k2])) continue;
                    found = true;
                    if (!collection[j].findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList<SecurityConstraint>();
                    }
                    results.add(constraints[i]);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                int length = -1;
                for (k = 0; k < patterns.length; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (!pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                found = true;
                if (length > longest) {
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!collection[j].findMethod(method)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            boolean matched2 = false;
            int pos = -1;
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (k = 0; k < patterns.length && !matched2; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf("/");
                    int dot = uri.lastIndexOf(".");
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched2 = true;
                    pos = j;
                }
            }
            if (!matched2) continue;
            found = true;
            if (!collection[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList();
            }
            results.add(constraints[i]);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                for (int k3 = 0; k3 < patterns.length && !matched; ++k3) {
                    String pattern2 = patterns[k3];
                    if (!pattern2.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (results == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList results) {
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getDecodedRequestURI();
            String loginPage = context.getPath() + config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to login page " + loginPage));
                }
                return true;
            }
            String errorPage = context.getPath() + config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to error page " + errorPage));
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Allow access to username/password submission");
                }
                return true;
            }
        }
        Principal principal = request.getUserPrincipal();
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String[] roles = constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (constraint.getAllRoles()) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (roles.length == 0) {
                if (constraint.getAuthConstraint()) {
                    response.sendError(403, sm.getString("realmBase.forbidden"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No roles ");
                    }
                    return false;
                }
                log.debug((Object)"Passing all access");
                return true;
            }
            if (principal == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No user authenticated, cannot grant access");
                }
                response.sendError(403, sm.getString("realmBase.notAuthenticated"));
                return false;
            }
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(principal, roles[j])) {
                    return true;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + roles[j]));
            }
        }
        response.sendError(403, sm.getString("realmBase.forbidden"));
        return false;
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        if (gp.getRealm() != this) {
            log.debug((Object)("Different realm " + this + " " + gp.getRealm()));
        }
        boolean result = gp.hasRole(role);
        if (log.isDebugEnabled()) {
            String name = principal.getName();
            if (result) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", name, role));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", name, role));
            }
        }
        return result;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals("NONE")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuffer file = new StringBuffer();
        String protocol = "https";
        String host = request.getServerName();
        file.append(protocol).append("://");
        file.append(host).append(":").append(redirectPort);
        file.append(request.getRequestURI());
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = request.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + file.toString()));
        }
        response.sendRedirect(file.toString());
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            log.info((Object)sm.getString("realmBase.alreadyStarted"));
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", this.digest), e);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            log.info((Object)sm.getString("realmBase.notStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
        this.destroy();
    }

    public void destroy() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
                log.debug((Object)("unregistering realm " + this.oname));
            }
            catch (Exception ex) {
                log.error((Object)("Can't unregister realm " + this.oname), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                if (this.getDigestEncoding() == null) {
                    bytes = credentials.getBytes();
                } else {
                    try {
                        bytes = credentials.getBytes(this.getDigestEncoding());
                    }
                    catch (UnsupportedEncodingException uee) {
                        log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                        throw new IllegalArgumentException(uee.getMessage());
                    }
                }
                this.md.update(bytes);
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception e) {
                log.error((Object)sm.getString("realmBase.digest"), (Throwable)e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Couldn't get MD5 digest: ", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = digestValue.getBytes();
        } else {
            try {
                valueBytes = digestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        byte[] digest = md5Helper.digest(valueBytes);
        return md5Encoder.encode(digest);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected abstract Principal getPrincipal(String var1);

    public static final String Digest(String credentials, String algorithm) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            md.update(credentials.getBytes());
            return HexUtils.convert(md.digest());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return credentials;
        }
    }

    public static void main(String[] args) {
        if (args.length > 2 && args[0].equalsIgnoreCase("-a")) {
            for (int i = 2; i < args.length; ++i) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.Digest(args[i], args[1]));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> <credentials>");
        }
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        this.host = name.getKeyProperty("host");
        this.path = name.getKeyProperty("path");
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void init() {
        if (this.initialized && this.container != null) {
            return;
        }
        this.initialized = true;
        if (this.container == null) {
            ObjectName parent = null;
            try {
                parent = this.host == null ? new ObjectName(this.domain + ":type=Engine") : (this.path == null ? new ObjectName(this.domain + ":type=Host,host=" + this.host) : new ObjectName(this.domain + ":j2eeType=WebModule,name=//" + this.host + this.path));
                if (this.mserver.isRegistered(parent)) {
                    log.debug((Object)("Register with " + parent));
                    this.mserver.setAttribute(parent, new Attribute("realm", this));
                }
            }
            catch (Exception e) {
                log.info((Object)("Parent not available yet: " + parent));
            }
        }
        if (this.oname == null) {
            try {
                ContainerBase cb = (ContainerBase)this.container;
                this.oname = new ObjectName(cb.getDomain() + ":type=Realm" + cb.getContainerSuffix());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                log.debug((Object)("Register Realm " + this.oname));
            }
            catch (Throwable e) {
                log.error((Object)("Can't register " + this.oname), e);
            }
        }
    }

    static {
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

