/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.cluster.deploy.FileChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WarWatcher
implements Runnable {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$deploy$WarWatcher == null ? (class$org$apache$catalina$cluster$deploy$WarWatcher = WarWatcher.class$("org.apache.catalina.cluster.deploy.WarWatcher")) : class$org$apache$catalina$cluster$deploy$WarWatcher));
    protected File deployDir = null;
    protected FileChangeListener listener = null;
    protected long interval = 5000L;
    protected boolean alive = true;
    protected Map currentStatus = new HashMap();
    static /* synthetic */ Class class$org$apache$catalina$cluster$deploy$WarWatcher;

    public WarWatcher(FileChangeListener listener, File deployDir, long interval) {
        this.listener = listener;
        this.deployDir = deployDir;
        this.interval = interval;
    }

    public void run() {
        while (this.alive) {
            try {
                File[] list = this.deployDir.listFiles(new WarFilter());
                if (list == null) {
                    list = new File[]{};
                }
                for (int i = 0; i < list.length; ++i) {
                    this.addWarInfo(list[i]);
                }
                Iterator i = this.currentStatus.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    WarInfo info = (WarInfo)entry.getValue();
                    int check = info.check();
                    if (check == 1) {
                        this.listener.fileModified(info.getWar());
                        continue;
                    }
                    if (check != -1) continue;
                    this.listener.fileRemoved(info.getWar());
                    this.currentStatus.remove(info.getWar());
                }
                Thread.sleep(this.interval);
            }
            catch (Exception x) {
                log.error((Object)"Unable to watch for WAR deployments in cluster.", (Throwable)x);
            }
        }
    }

    protected void addWarInfo(File f) {
        WarInfo info = (WarInfo)this.currentStatus.get(f.getAbsolutePath());
        if (info == null) {
            info = new WarInfo(f);
            info.setLastState(-1);
            this.currentStatus.put(f.getAbsolutePath(), info);
        }
    }

    public void stop() {
        this.alive = false;
        this.currentStatus.clear();
        this.listener = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class WarInfo {
        protected File war = null;
        protected long lastChecked = 0L;
        protected long lastState = 0L;

        public WarInfo(File war) {
            this.war = war;
            this.lastChecked = war.lastModified();
            if (!war.exists()) {
                this.lastState = -1L;
            }
        }

        public boolean modified() {
            return this.war.exists() && this.war.lastModified() > this.lastChecked;
        }

        public boolean exists() {
            return this.war.exists();
        }

        public int check() {
            int result = 0;
            if (this.modified()) {
                result = 1;
                this.lastState = result;
            } else if (!this.exists() && this.lastState != -1L) {
                result = -1;
                this.lastState = result;
            } else if (this.lastState == -1L && this.exists()) {
                result = 1;
                this.lastState = result;
            }
            this.lastChecked = System.currentTimeMillis();
            return result;
        }

        public File getWar() {
            return this.war;
        }

        public int hashCode() {
            return this.war.getAbsolutePath().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof WarInfo) {
                WarInfo wo = (WarInfo)other;
                return wo.getWar().equals(this.getWar());
            }
            return false;
        }

        protected void setLastState(int lastState) {
            this.lastState = lastState;
        }
    }

    protected class WarFilter
    implements FilenameFilter {
        protected WarFilter() {
        }

        public boolean accept(File path, String name) {
            if (name == null) {
                return false;
            }
            return name.endsWith(".war");
        }
    }
}

