﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using FF.Models;
using FF.Services;

namespace FF.Controllers
{
    public class TeamController : Controller
    {
        private IOwnerService _ownerService;
        private ITeamService _teamService;
        public TeamController()
        {
            _ownerService = new OwnerService();
            _teamService = new TeamService();
        }

        public TeamController(IOwnerService ownerService, ITeamService teamService)
        {
            
            _ownerService = ownerService;
            _teamService = teamService;
        }

        // GET: Team
        public ActionResult Index()
        {
            Owner owner = _ownerService.GetOwnerById(1);
            Team team = _teamService.GetTeamByOwnerId(1);
            TeamViewModel viewModel = new TeamViewModel();
            foreach (var player in team.Players)
            {
                PlayerViewModel playerViewModel = new PlayerViewModel();
                playerViewModel.PlayerName = player.first_name + " " + player.last_name;
                playerViewModel.Position = player.PlayerType.PlayerTypeName;
                viewModel.Roster.Add(playerViewModel);
            }
            
            viewModel.Owner = new OwnerViewModel();
            viewModel.Owner.OwnerName = owner.username;
            viewModel.Owner.CreatedDate = Convert.ToDateTime(owner.createdate);
            viewModel.TeamName = team.team_name;

            return View(viewModel);
        }

        //Get: Team/Matchups
        public ActionResult Matchups()
        {
            return View();
        }
    }
}