﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using FF.Repositories;

namespace FF.Services
{
    public class OwnerService : IOwnerService
    {
        private IRepository<Owner> _ownerRepository;

        public OwnerService(IRepository<Owner> ownerRepository = null)
        {
            if (ownerRepository == null)
            {
                var context = new FFEntities();
                _ownerRepository = new GenericRepository<Owner>(context);
            }
            else
            {
                _ownerRepository = ownerRepository;
            }
        }

        public Owner GetOwnerById(int id)
        {
            return _ownerRepository.GetById(id);
        }
    }
}