﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using FF.Repositories;

namespace FF.Services
{
    public class TeamService : ITeamService
    {
        private IRepository<Team> _teamRepository;

        public TeamService(IRepository<Team> ownerRepository = null)
        {
            if (ownerRepository == null)
            {
                var context = new FFEntities();
                _teamRepository = new GenericRepository<Team>(context);
            }
            else
            {
                _teamRepository = ownerRepository;
            }
        }

        public Team GetTeamById(int id)
        {
            return _teamRepository.GetById(id);
        }

        public Team GetTeamByOwnerId(int id)
        {
            return _teamRepository.Where(t => t.OwnerID == id).First();
        }
    }
}