﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace FF.Repositories
{
    public class UnitOfWork : IUnitOfWork
    {
        private IRepository<Team> _teamRepository;
        private IRepository<Owner> _ownerRepository;

        private FFEntities _context;
        public UnitOfWork()
        {
            _context = new FFEntities();
        }

        public IRepository<Team> TeamRepository
        {
            get { return _teamRepository ?? (_teamRepository = new GenericRepository<Team>(_context)); }
        }

        public IRepository<Owner> OwnerRepository
        {
            get
            {
                if (_ownerRepository == null)
                {
                    _ownerRepository = new GenericRepository<Owner>(_context);
                }
                return _ownerRepository;
            }
        }

        public bool Save()
        {
            _context.SaveChanges();
            return true;
        }
    }
}