﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using FF.Repositories;

namespace FF.Services
{
    public class TeamService : ITeamService
    {
        private IUnitOfWork _unitOfWork;

        public TeamService(IUnitOfWork unitOfWork)
        {
            _unitOfWork = unitOfWork;

        }

        public Team GetTeamById(int id)
        {
            return _unitOfWork.TeamRepository.GetById(id);
        }

        public Team GetTeamByOwnerId(int id)
        {
            return _unitOfWork.TeamRepository.Where(t => t.OwnerID == id).First();
        }

        public bool UpdateTeamName(string teamName, int teamId)
        {
            var result = false;
            if (!string.IsNullOrEmpty(teamName))
            {
                var team = _unitOfWork.TeamRepository.GetById(teamId);
                if (team != null)
                {
                    team.TeamName = teamName;
                    result = _unitOfWork.Save();
                }
            }
            return result;
        }
    }
}