/** Table Creation Scripts **/


/* TABLE CREATION */

CREATE TABLE PlayerTypes
(
	PlayerTypeID int IDENTITY(1,1) PRIMARY KEY,
	PlayerTypeName varchar(20) NOT NULL
)

CREATE TABLE Leagues
(
	LeagueID int IDENTITY(1,1) PRIMARY KEY,
	league_name varchar(20) NOT NULL
)

CREATE TABLE Owners
(
	OwnerID int IDENTITY(1,1) PRIMARY KEY,
	username varchar(30) NOT NULL,
	password varchar(20) NOT NULL,
	commissioner_flag bit NOT NULL,
	LeagueID int FOREIGN KEY REFERENCES Leagues(LeagueID),
	createdate smalldatetime
)

CREATE TABLE Teams
(
	TeamID int IDENTITY(1,1) PRIMARY KEY,
	team_name varchar(20) NOT NULL,
	OwnerID int FOREIGN KEY REFERENCES Owners(OwnerID),
	LeagueID int FOREIGN KEY REFERENCES Leagues(LeagueID)
)

CREATE TABLE Players
(
	PlayerID int IDENTITY(1,1) PRIMARY KEY,
	first_name varchar(20) NOT NULL,
	last_name varchar(20) NOT NULL,
	player_health varchar(20) NOT NULL,
	PlayerTypeID int FOREIGN KEY REFERENCES PlayerTypes(PlayerTypeID),
	TeamID int FOREIGN KEY REFERENCES Teams(TeamID)
)


CREATE TABLE Matchups
(
	MatchupID int IDENTITY(1,1) PRIMARY KEY,
	Week int NOT NULL,
	HomeTeamID int FOREIGN KEY REFERENCES Teams(TeamID),
	VisitingTeamID int FOREIGN KEY REFERENCES Teams(TeamID)

)

CREATE TABLE DefensePerformances
(
	PlayerTypeID int FOREIGN KEY REFERENCES PlayerTypes(PlayerTypeID),
	week int NOT NULL,
	sacks int,
	interceptions int,
	fumble_recovery int,
	PRIMARY KEY (PlayerTypeID, week)
)

CREATE TABLE OffensivePerformances
(
	PlayerTypeID int FOREIGN KEY REFERENCES PlayerTypes(PlayerTypeID),
	week int NOT NULL,
	passing_yards int,
	passint_td int,
	passing_int int,
	rushing_yards int,
	rushing_td int
)

CREATE TABLE KickingPerformances
(
	PlayerTypeID int FOREIGN KEY REFERENCES PlayerTypes(PlayerTypeID),
	week int NOT NULL,
	FG0To19 int,
	FG20To29 int,
	FG30To39 int,
	FG40To49 int,
	FGOver49 int,
	missed int,
	extra_point int
)

/** DATA INSERTION **/

INSERT INTO PlayerTypes VALUES
('Quarterback'),
('Running Back'),
('Wide Receiver'),
('Tight End'),
('Kicker'),
('Defense')

INSERT INTO Leagues VALUES
('Ultimate')

INSERT INTO Owners VALUES
('eanyanwu','mypassword',0,1, GetDate()),
('craze','notmypassword',0,1, GetDate()),
('gordon.edu','getitdone',1,1, GetDate()),
('Vaughan','gordon123',0,1, GetDate()),
('clint','123',0,1, GetDate()),
('anaxagoras','hefin',0,1, GetDate()),
('ralf','yo837',0,1, GetDate()),
('gottlob','h374id2',0,1, GetDate()),
('Erastus','startupspeed',0,1, GetDate()),
('gennady','dev-test',0,1, GetDate())


INSERT INTO Teams VALUES
('Death at the Net',1,1),
('Spike it',2,1),
('The END',3,1),
('Famous Slammers',4,1),
('Nile Ozone',4,1),
('Irrelevant Ducks',5,1),
('Actively IDLE',6,1),
('Struggling',7,1),
('We Will Overcome',8,1),
('The Pentecostals', 9,1),
('Idly Active',10,1)


INSERT INTO Players VALUES
('Samuel','Goldemann','Sick',1,1),
('David','Silvermann','Sick',2,1),
('Assad','Lion','Healthy',2,1),
('Bilal','Wake','Healthy',3,1),
('Carter','Crocket','Fit',3,1),
('Dimitry','Lion','Fit',4,1),
('Ean','New','Fit',5,1),
('Fred','Ussop','Healthy',6,1),
('Graham','Heller','Fit',3,1),
('Hassan','Benhamid','Fit',3,1);

INSERT INTO Matchups VALUES
(1,1,10),
(2,1,9),
(3,1,8),
(4,1,7),
(5,1,6),
(6,5,1),
(7,6,1),
(8,7,1),
(9,8,1),
(10,9,1),
(11,10,1);