/** SELECT QUERIES **/


/** Selects owner username, team name and league name for a given owner id **/
select username, team_name, league_name
from Owners, Teams t1 join Leagues t2
on t1.LeagueID = t2.LeagueID
where Owners.OwnerID = t1.OwnerID and Owners.OwnerID = 2 -- Enter Specific OwnerID here 



/** Select all matchups for specific team **/ 
select m.MatchupID,
	t1.team_name, 
	t2.team_name
from Matchups as m
	 join Teams as t1 
		on t1.TeamID = m.HomeTeamID
	 join Teams as t2 
		on t2.TeamID = m.VisitingTeamID
where t1.TeamID = 1 or t2.TeamID = 1 -- Optional line for specifying the team
