﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using NUnit.Framework;

using Untouchables;
namespace Tests
{
    [TestFixture]
    public class EDRPinningTests
    {
        private Game game;
        private MockGalaxy context;

        const int EnergyInNewGame = 10000;

        [TearDown] // run after every test
        public void RemoveTheMockRandomGeneratorForOtherTests_IReallyWantToRefactorThatStaticVariableSoon()
        {
            Game.generator = new Random();
        }

        [SetUp] //run before every test
        public void SetUp()
        {
            game = new Game();
            context = new MockGalaxy();
            context.SetValueForTesting("command", "edr");
        }

        [Test]
        public void EDR_HalfEngeryGone()
        {
            int expectedEnergy = EnergyInNewGame / 2;
            context.SetValueForTesting("amount", (expectedEnergy).ToString());
            game.FireWeapon(context);
            //Assert.AreEqual("Insufficient energy to fire phasers! || ",
            //    context.GetAllOutput());
            Assert.AreEqual(expectedEnergy, game.EnergyRemaining());
        }

        [Test]
        public void EDR_FireTwice()
        {
            int expectedEnergy = EnergyInNewGame / 2;
            context.SetValueForTesting("amount", (expectedEnergy).ToString());
            
            //fire once
            game.FireWeapon(context);
            
            //Fire Twice
            game.FireWeapon(context);

            Assert.AreEqual("EDR already fired! || ",
                context.GetAllOutput());
           
        }
    }
}
