/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class AddressBookController {
    private FileSystem fileSystem;

    public AddressBookController(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void doAdd(AddressBookGUI addressBookGUI) {
        String[] stringArray = new String[]{"First Name", "Last Name", "Address", "City", "State", "ZIP", "Phone"};
        String[] stringArray2 = MultiInputPane.showMultiInputDialog((Component)addressBookGUI, stringArray, "Person to add");
        if (stringArray2 != null) {
            addressBookGUI.getAddressBook().addPerson(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], stringArray2[4], stringArray2[5], stringArray2[6]);
        }
    }

    public void doEdit(AddressBookGUI addressBookGUI, int n) {
        String string = addressBookGUI.getAddressBook().getFullNameOfPerson(n);
        String[] stringArray = addressBookGUI.getAddressBook().getOtherPersonInformation(n);
        String[] stringArray2 = new String[]{"Address", "City", "State", "ZIP", "Phone"};
        String[] stringArray3 = MultiInputPane.showMultiInputDialog(addressBookGUI, stringArray2, stringArray, "Edit " + string);
        if (stringArray3 != null) {
            addressBookGUI.getAddressBook().updatePerson(n, stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[3], stringArray3[4]);
        }
    }

    public void doDelete(AddressBookGUI addressBookGUI, int n) {
        String string = addressBookGUI.getAddressBook().getFullNameOfPerson(n);
        if (JOptionPane.showConfirmDialog(addressBookGUI, "Are you sure you want to delete " + string + "?", "Confirm delete", 0) == 0) {
            addressBookGUI.getAddressBook().removePerson(n);
        }
    }

    public void doSortByName(AddressBookGUI addressBookGUI) {
        addressBookGUI.getAddressBook().sortByName();
    }

    public void doSortByZip(AddressBookGUI addressBookGUI) {
        addressBookGUI.getAddressBook().sortByZip();
    }

    public void doPrint(AddressBookGUI addressBookGUI) {
        addressBookGUI.getAddressBook().printAll();
    }

    public void doNew(AddressBookGUI addressBookGUI) {
        addressBookGUI.setAddressBook(new AddressBook());
    }

    public void doOpen(AddressBookGUI addressBookGUI) throws IOException, ClassCastException, ClassNotFoundException, InterruptedException, SecurityException {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (jFileChooser.showOpenDialog(addressBookGUI) != 0) {
            throw new InterruptedException("Cancelled by user");
        }
        File file = jFileChooser.getSelectedFile();
        addressBookGUI.setAddressBook(this.fileSystem.readFile(file));
    }

    public void doSave(AddressBookGUI addressBookGUI) throws IOException, InterruptedException, SecurityException {
        File file = addressBookGUI.getAddressBook().getFile();
        if (file == null) {
            this.doSaveAs(addressBookGUI);
        } else {
            this.fileSystem.saveFile(addressBookGUI.getAddressBook(), file);
        }
    }

    public void doSaveAs(AddressBookGUI addressBookGUI) throws IOException, InterruptedException, SecurityException {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (jFileChooser.showSaveDialog(addressBookGUI) != 0) {
            throw new InterruptedException("Cancelled by user");
        }
        File file = jFileChooser.getSelectedFile();
        this.fileSystem.saveFile(addressBookGUI.getAddressBook(), file);
    }

    public void doOfferSaveChanges(AddressBookGUI addressBookGUI) throws InterruptedException, IOException, SecurityException {
        int n = JOptionPane.showConfirmDialog(addressBookGUI, "There are unsaved changes.  Save them?", "Save changes", 1);
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                this.doSave(addressBookGUI);
                break;
            }
            default: {
                throw new InterruptedException("Cancelled by user");
            }
        }
    }
}

